@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add New Tax</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('tax-store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="taxName" class="form-label">Tax Name</label>
                                    <input type="text" id="taxName" name="taxName" class="form-control"
                                        value="{{ old('taxName') }}" placeholder="e.g. VAT, GST" required>
                                    @error('taxName')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="taxValue" class="form-label">Tax Value (%)</label>
                                    <input type="number" step="0.01" id="taxValue" name="taxValue" class="form-control"
                                        value="{{ old('taxValue') }}" placeholder="e.g. 12.5" required>
                                    @error('taxValue')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Is Active</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isDefaultYes" class="form-check-input" name="isDefault"
                                                value="1" {{ old('isDefault') == '1' ? 'checked' : '' }} required>
                                            <label for="isDefaultYes" class="form-check-label">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isDefaultNo" class="form-check-input" name="isDefault"
                                                value="0" {{ old('isDefault') == '0' ? 'checked' : '' }} required>
                                            <label for="isDefaultNo" class="form-check-label">No</label>
                                        </div>
                                    </div>
                                    @error('isDefault')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Is Default</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="show_flg_yes" class="form-check-input" name="show_flg"
                                                value="Y" {{ old('show_flg') == 'Y' ? 'checked' : '' }} required>
                                            <label for="show_flg_yes" class="form-check-label">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="show_flg_no" class="form-check-input" name="show_flg"
                                                value="N" {{ old('show_flg') == 'N' ? 'checked' : '' }} required>
                                            <label for="show_flg_no" class="form-check-label">No</label>
                                        </div>
                                    </div>
                                    @error('show_flg')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Save Tax</button>
                                <a href="{{ route('tax-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection